<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingsSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            // General
            [
                'key' => 'site_name',
                'value' => 'MasjidVision',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Nama Masjid',
            ],
            [
                'key' => 'logo_path',
                'value' => null,
                'type' => 'image',
                'group' => 'general',
                'label' => 'Logo Masjid',
            ],

            // Hero Section
            [
                'key' => 'hero_title',
                'value' => 'Pusat Ibadah & Kegiatan Umat',
                'type' => 'text',
                'group' => 'hero',
                'label' => 'Judul Hero',
            ],
            [
                'key' => 'hero_subtitle',
                'value' => 'Masjid Al-Hidayah, Jl. Contoh No. 123, Jakarta Selatan',
                'type' => 'textarea',
                'group' => 'hero',
                'label' => 'Subjudul / Alamat Singkat',
            ],
            [
                'key' => 'hero_bg_image',
                'value' => 'https://images.unsplash.com/photo-1519817650390-64a93db51149?q=80&w=2000&auto=format&fit=crop',
                'type' => 'image',
                'group' => 'hero',
                'label' => 'Background Hero',
            ],

            // Contact
            [
                'key' => 'address',
                'value' => 'Jl. Contoh No. 123, Jakarta Selatan, DKI Jakarta 12345',
                'type' => 'textarea',
                'group' => 'contact',
                'label' => 'Alamat Lengkap',
            ],
            [
                'key' => 'email',
                'value' => 'info@masjidalhidayah.com',
                'type' => 'text',
                'group' => 'contact',
                'label' => 'Email',
            ],
            [
                'key' => 'phone',
                'value' => '+62 812 3456 7890',
                'type' => 'text',
                'group' => 'contact',
                'label' => 'Nomor Telepon',
            ],
            [
                'key' => 'whatsapp',
                'value' => '6281234567890',
                'type' => 'text',
                'group' => 'contact',
                'label' => 'Nomor WhatsApp (format: 62...)',
            ],
            [
                'key' => 'maps_embed_url',
                'value' => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d126907.08660340324!2d106.726588!3d-6.284028!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e69f0322ba7b2c7%3A0x6e6e28ce073c1d0!2sMasjid%20Istiqlal!5e0!3m2!1sid!2sid!4v1705739000000!5m2!1sid!2sid',
                'type' => 'textarea',
                'group' => 'contact',
                'label' => 'Link Google Maps Embed',
            ],

            // Social Media
            [
                'key' => 'facebook_url',
                'value' => '#',
                'type' => 'text',
                'group' => 'social',
                'label' => 'Facebook URL',
            ],
            [
                'key' => 'instagram_url',
                'value' => '#',
                'type' => 'text',
                'group' => 'social',
                'label' => 'Instagram URL',
            ],
            [
                'key' => 'youtube_url',
                'value' => '#',
                'type' => 'text',
                'group' => 'social',
                'label' => 'YouTube URL',
            ],

            // Footer
            [
                'key' => 'footer_text',
                'value' => 'Masjid Al-Hidayah adalah pusat kegiatan ibadah dan sosial kemasyarakatan yang bertujuan membangun peradaban islam yang rahmatan lil alamin.',
                'type' => 'textarea',
                'group' => 'footer',
                'label' => 'Teks Footer',
            ],
            [
                'key' => 'copyright_text',
                'value' => '© 2024 Masjid Al-Hidayah. All rights reserved.',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'Teks Copyright',
            ],
            
            // Location (for prayer times)
            [
                'key' => 'location_latitude',
                'value' => '-6.200000',
                'type' => 'text',
                'group' => 'location',
                'label' => 'Latitude (Koordinat Lintang)',
            ],
            [
                'key' => 'location_longitude',
                'value' => '106.816666',
                'type' => 'text',
                'group' => 'location',
                'label' => 'Longitude (Koordinat Bujur)',
            ],
            [
                'key' => 'location_city',
                'value' => 'Jakarta',
                'type' => 'text',
                'group' => 'location',
                'label' => 'Kota/Daerah',
            ],
            [
                'key' => 'location_timezone',
                'value' => 'Asia/Jakarta',
                'type' => 'text',
                'group' => 'location',
                'label' => 'Zona Waktu',
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
